@echo off

rem Activate Command Extensions, Terminate on failure (Win 95/98/ME)
verify errors 2 > nul
setlocal ENABLEEXTENSIONS
if ERRORLEVEL 1 goto noextensions

rem if on Windows Vista check if script is running with administrative 
rem privileges by executing the openfiles command, which will exit with
rem errorlevel 1 when running as non-administrator
ver | find "6." > nul
if %ERRORLEVEL% == 0 (
  rem Do fsutil to check for administrative privileges
  openfiles > nul 2>&1
  if ERRORLEVEL 1 (
    @echo *** 
    @echo *** ERROR!
    @echo *** You have to run "%~n0" as administrator.
    @echo *** Right click on "%~n0" and choose "Run as Administrator".
    @echo *** 
    pause
    goto end
  )
)

rem Ensure that the directory in which the script runs is the current
rem directory. This could not be true if for example we are
rem running on Vista with the "Run as Administrator" option
cd /d %~dp0

rem Set the name of directory where to install cpx files on target
set CPXDIR=
if exist version.bat call version.bat
if '%CPXDIR%'=='' goto nocpxdir

rem If no drive letter was passed ask for one
set interactive=
set target=
if '%1'=='' goto enterdrive else (
  set target=%1
  goto targetavailable
)
:enterdrive
set choice=
set interactive=yes
@echo .
@echo Enter drive letter where you want to install Abilis
set /p choice=(D: .. Z: , press Enter to abort):
if /i '%choice%'=='' goto end 
if not '%choice%'=='' set target=%choice%
vol %target% > nul 
if ERRORLEVEL 1 ( 
  echo "%choice%" is not valid please try again.
  goto enterdrive 
)
goto targetavailable

rem Verify that an acceptable drive letter has been passed
:targetavailable
if /i '%target%' == 'c:' goto systemdrive
if /i '%target%' == 'a:' goto floppydrive
if /i '%target%' == 'b:' goto floppydrive
if /i '%target%' == '/h' goto help

rem Verify that the drive exists
vol %target% > nul 
if ERRORLEVEL 1 goto errordrive

rem Warn that boot sector will be rewritten and ask to proceed.
@echo *** 
@echo *** You requested to install Abilis CPX software v.%CPXDIR% on drive '%target%'.
@echo *** This procedure makes disk in '%target%' bootable with Abilis CPX sw.
@echo *** Once the software is installed, the hard disk or compact flash must be
@echo *** safely removed from the Windows computer and installed in the Abilis CPX 
@echo *** system while it's powered off.
@echo *** 
@echo *** Caution! You have requested to replace the boot sector on hard disk '%target%'.
@echo *** You will NOT be able to boot the current OS
@echo *** from disk once this program has completed.
@echo .
:confirm
set choice=
set /p choice=Do you want to continue (Y = Yes, N = No, press N to abort)?
if not '%choice%'=='' set choice=%choice:~0,1%
if /i '%choice%'=='y' goto confirmed 
if /i '%choice%'=='n' goto end
echo "%choice%" is not valid please try again
goto confirm

:confirmed
if not exist files mkdir files
if exist cpx.pkg goto std
if exist hcpx.pkg goto vmx

rem Prepare Abilis STD
:std
bootdisk.exe /y bm.rtb %target%
@echo Boot sector and Abilis boot loader successfully installed!
if ERRORLEVEL 1 goto bootdiskerr
cd files
..\pkgmake -x -p..\cpx.pkg -y
cd ..
goto copyfiles

rem Prepare Abilis VMX
:vmx
rem Put the output of grubdisk.exe into variable disk_id
for /f "tokens=*" %%a in ('grubdisk -p %target%') do (set disk_id=%%a)
rem check that we are not trying to install on first disk, which is likely the system disk
if '%disk_id:~0,1%' == '0' goto systemdrive
rem check that there wasn't error
if '%disk_id:~0,1%' == '-' goto errordrive
rem Install grub4dos in the partition boot sector, not in mbr.
grubinst -v -2 --time-out=0 (hd%disk_id%)
if ERRORLEVEL 1 goto grubinsterr 
rem grubinst bypasses the Windows cache, this tools synchronises the cache with a trick:
rem it reads the boot sector and writes back. Use it immediately after grubinst.
touchdrv %target%
if ERRORLEVEL 1 goto touchdrverr 
@echo Boot sector successfully installed!
cd files
..\pkgmake -x -p..\hcpx.pkg -y
cd ..
if not exist boot mkdir boot
cd boot
..\pkgmake -x -p..\boot.pkg -y
cd ..
xcopy hbm.rtb %target% /Y
xcopy g2ldr %target% /Y
xcopy boot\*.* %target%\boot\*.* /S /E /Y
goto copyfiles

:copyfiles
if not exist %target%\LICENCE mkdir %target%\LICENCE
xcopy files\*.*    %target%\%CPXDIR%\*.* /S /E /EXCLUDE:exclude.txt /Y
xcopy .\drivers.*  %target%\%CPXDIR%\*.* /Y
xcopy .\factory.cfg  %target%\%CPXDIR%\*.* /Y
xcopy files\c\*.*  %target%\*.* /S /E /Y
@echo ***
@echo *** COMPLETED
@echo *** 
goto end

:nocpxdir
@echo *** 
@echo *** ERROR!
@echo *** It was not possible to determine the Abilis CPX software version.
@echo *** The file "version.bat" is missing or corrupted.
@echo *** 
goto end

:help
@echo ***
@echo *** Install Abilis CPX on a drive mounted under Windows 2000/XP/VISTA/SEVEN.
@echo *** Once the software is installed, the drive must be safely removed   
@echo *** and installed in the Abilis CPX system while it's powered off.
@echo ***
@echo *** Running install without parameters will prompt for the drive letter. 
@echo ***
@echo *** Usage:
@echo ***   INSTALL [drive]    - Install on specified drive
@echo ***   INSTALL /H         - Shows this help
@echo ***
@echo *** Example:
@echo ***   INSTALL G:
@echo ***
goto end

:systemdrive
@echo ***
@echo *** ERROR!
@echo *** The drive you specified ('%target%') is the first drive,
@echo *** it is probably your Windows system drive or a partition on it!
@echo *** Drives 'A:', 'B:', 'C:' and other system drive partitions 
@echo *** cannot be used for CPX installation.
@echo ***
goto end

:floppydrive
@echo ***
@echo *** ERROR!
@echo *** You specified drive 'A:' or 'B:' which are reserved to floppy drives!
@echo *** Drives 'A:', 'B:' and 'C:' cannot be used for CPX installation.
@echo ***
goto end

:errordrive
@echo ***
@echo *** ERROR!
@echo *** The drive you specified ('%target%') is not available, possible reasons:
@echo *** - you did not specify a valid drive letter
@echo *** - the drive is not functional
@echo *** - the removable media is not inserted in the drive
@echo ***
goto end

:noextensions
@echo *** ERROR!
@echo *** Cannot enable Windows command extensions.
goto end

:grubinsterr
@echo *** ERROR!
@echo *** Boot sector installation failure.
goto end

:touchdrverr
@echo *** ERROR!
@echo *** Boot sector verification failure.
goto end

:bootdiskerr
@echo *** ERROR!
@echo *** Boot sector installation failure.
goto end

:end
if '%interactive%'=='yes' pause
